;
; Narciarzyki
;idea&gfx 	- Innuendo
;fx			- Miker
;code		- . .- --. .-.. .
;----------------------------
;Atasm-Mac/65
;
	.include innuendo\lib.m65

*	= $2e0
	.word start

*	= $2000		;hmmm może nizej? 
Start
	systemoff
		waitsync
			moveekran
newgame
		waitsync
	lda #$00
	sta flagvb
		displaylist dlmenu
			dlistinter	dli
	lda #$c0
	sta $d40e
	lda	#~00101110 
	sta $d400
		czekajnatriger
			waitsync
				clearscore
				jsr showscore
	lda #$01
	sta flagvb
		displaylist dlgame
			dlistinter	dliGame
	lda #50
	sta @loop
;**********************************************
mainloop
	flagastatus down	
		animuj 0
			fx 1
				petla
			flagastatus up
			lda #$00
			sta liczskok
			sta falstart
		fx 0
	petla
	reanimuj 0
		animation 1,1
			animation 2,1
				flagastatus down
			waitclock
	waitclock
	lda powerindicator
	and #$03
	beq tabskokow+6	
	cmp #01
	beq tabskokow
	cmp #2
	beq tabskokow+3
	jmp skoklong
tabskokow
	jmp skokshort
	jmp skokmidle
	jmp	skoknaryj
skokshort
	animation 3,niski
		animation 4,niski
			animation 5,niski
		animation 6,wysoki
	jsr proc_add_1
	przyszpiesz
	jmp	mainloop

skokmidle
	animation 3,niski
		animation 4,niski
			animation 7,niski
				animation 8,niski
					animation 9,niski
						animation 10,wysoki
					jsr proc_add_1
				jsr proc_add_1
			jsr proc_add_1
		przyszpiesz
	jmp mainloop

skoklong
	animation 3,niski
		animation 4,niski
			animation 7,niski
				animation 11,niski
					animation 12,niski
				animation 13,niski
			animation 14,wysoki
		ldx #$01
		jsr add_free
		przyszpiesz
	jmp mainloop

skoknaryj
	animuj 15
		fx crash
			petla
				petla
					reanimuj 15
				flagastatus down
				lda #$00
				sta flagvb
			petla
		czekajnatriger
	jmp newgame

wynik	
	.byte 0,0,0,0,0

proc_add_1
	ldx #$00
add_free
	lda wynik,x
	clc
	adc #$01
	cmp #10
	beq add_next
	sta wynik,x
	rts
add_next
	lda #$00
	sta wynik,x
	inx
	jmp add_free


@loop	.byte 0
flagvb	.byte 0
@clock	.byte 0

VBL
	jsr shadows
	inc @clock
	lda flagvb
	bne muzon
	jsr $3409	;silencium
	rts
muzon
	jsr chkfire
	jsr calculatepower
	jsr chkpower
	jsr shwpower
	jsr jakilevel
	jsr showscore
	jsr $3403	;play music
	rts

jakilevel
	ldx @loop
	lda tablevel,x
	sta score+24
	rts

showscore
	lda wynik
	clc
	adc #$10
	sta score+13
	lda wynik+1
	clc
	adc #$10
	sta score+12
	lda wynik+2
	clc
	adc #$10
	sta score+11
	lda wynik+3
	clc
	adc #$10
	sta score+10
	lda wynik+4
	clc
	adc #$10
	sta score+9
	rts

tablevel
	.sbyte "99999999999999999999"
	.sbyte "88776665554444333322"
	.sbyte "22111100000"
tabpower	
	.sbyte "*   "
	.sbyte "**  "
	.sbyte "*** "
	.sbyte "****"

powerindicator	.byte 0

shwpower	;x-in
	stx powerindicator
	txa
	and #$03
	asl a
	asl a
	tax
	lda tabpower,x
	sta score+35
	lda tabpower+1,x
	sta score+36
	lda tabpower+2,x
	sta score+37
	lda tabpower+3,x
	sta score+38
	rts
chkpower
	lda liczskok
	bne jestpower
nopower
	ldx #$00
	rts
jestpower
	cmp minimum
	bmi nopower
	cmp fst
	bpl jestmoc
	ldx #$01
	rts
jestmoc
	cmp scnd
	bpl jakmalysz ;)
	ldx #$02
	rts
jakmalysz
	ldx #$03
	rts
	
calculatepower
	lda @loop
	sta minimum
	asl a
	clc
	adc @loop
;*3
	lsr a
	sta scnd	;50%
	lsr a
;/4 w a=25%
	clc
	adc @loop
	sta fst	;25%+33%
	lda @loop
	clc
	adc scnd
	sta scnd	;83%
	rts

minimum		.byte 0		;33%
fst			.byte 0		;33+25=58%
scnd		.byte 0		;33+25+25=83%


power 	.byte 0
liczskok .byte 0
falstart .byte 0

chkfire
	lda @flaga
	bne skokmozliwy
	lda trig0
	bne endchk
	sta liczskok
endchk
	rts
skokmozliwy
	lda falstart
	bne startcount
	lda trig0
	bne checkfalstart
	rts
checkfalstart
	lda #$01
	sta falstart
	rts
startcount
	lda trig0
	bne endcount
	inc liczskok
endcount
	rts


Shadows
	LDX #$08
?KOLORY	LDA Kolor,X
	STA $D012,X
	DEX 
	BPL ?KOLORY
	RTS
Kolor .byte 0,0,0,0,0,$0,$f,0,0

NMI
	bit $d40f
	bpl vblknmi
	jmp ($200)
vblknmi
	CLD 
	sta @a+1
	sty @a+3
	stx @a+5
	STA $d40f
	JSR VBL
@a	lda #$00
	ldy #$00
	ldx #$00
	RTI 


@flaga .byte 0

flagswap
	lda @flaga
	and #$01	;tak na wszelki wypadek
	asl a
	tax
	lda tabflag,x
	sta sour
	lda tabflag+1,x
	sta sour+1
	lda #<(gamescr+(40*129)+13)
	sta dest
	lda #>(gamescr+(40*129)+13)
	sta dest+1
	ldx #30
copyblok
	ldy #5
copylinie
	lda (sour),y
	sta (dest),y
	dey
	bpl copylinie
	lda sour
	clc
	adc #40
	sta sour
	bcc dodajdest2
	inc sour+1
dodajdest2
	lda dest
	clc
	adc #40
	sta dest
	bcc nextline2
	inc dest+1
nextline2
	dex
	bpl copyblok
	rts


@faz .byte 0
tabdest
	.word gamescr+(40*82)+1,gamescr+(40*90)+4,gamescr+(40*107)+7,gamescr+(40*90)+10
	.word gamescr+(40*75)+14,gamescr+(40*105)+17+1,gamescr+(40*130)+19+1
	.word gamescr+(40*35)+18,gamescr+(40*60)+24,gamescr+(40*100)+26,gamescr+(40*130)+27
	.word gamescr+(40*20)+26,gamescr+(40*55)+30,gamescr+(40*95)+34,gamescr+(40*130)+35
	.word gamescr+(40*130)+10,gamescr
tab_x
	.word 3,3,3,3,4,4,2,4,4,4,2,4,4,4,2,3,3	;align

tabfaz
	.word fazy,fazy+4,fazy+4,fazy+9
	.word fazy+13,fazy+13,fazy+19
	.word fazy+13,fazy+13,fazy+13,fazy+19
	.word fazy+13,fazy+13,fazy+13,fazy+19
	.word fazy,fazy
tabflag
	.word fazy+22,fazy+28	

anim
	lda @faz
	asl a
	tax
	lda tab_x,x
	sta @x+1
	lda tabfaz,x
	sta sour
	lda tabfaz+1,x
	sta sour+1
	lda @faz	
	asl a
	tax
	lda tabdest,x
	sta dest
	lda tabdest+1,x
	sta dest+1
;
	ldx #46
kopiujblok
@x	ldy #4		
kopiujlinie
	lda (sour),y
	ora (dest),y
	sta (dest),y
	dey
	bpl kopiujlinie
	lda sour
	clc
	adc #40
	sta sour
	bcc dodajdest
	inc sour+1
dodajdest
	lda dest
	clc
	adc #40
	sta dest
	bcc nextline
	inc dest+1
nextline
	dex
	bpl kopiujblok
	rts
;
gamescr2=$b000
tabkopia
	.word gamescr2+(40*82)+1,gamescr2+(40*90)+4,gamescr2+(40*107)+7,gamescr2+(40*90)+10
	.word gamescr2+(40*75)+14,gamescr2+(40*105)+17+1,gamescr2+(40*130)+19+1
	.word gamescr2+(40*35)+18,gamescr2+(40*60)+24,gamescr2+(40*100)+26,gamescr2+(40*130)+27
	.word gamescr2+(40*20)+26,gamescr2+(40*55)+30,gamescr2+(40*95)+34,gamescr2+(40*130)+35
	.word gamescr2+(40*130)+10,gamescr2
reanim
	lda @faz
	asl a
	tax
	lda tab_x,x
	sta @xx+1
	lda tabkopia,x
	sta sour
	lda tabkopia+1,x
	sta sour+1
	lda @faz	
	asl a
	tax
	lda tabdest,x
	sta dest
	lda tabdest+1,x
	sta dest+1
;
	ldx #46
kopiujblokx
@xx	ldy #4		
kopiujliniex
	lda (sour),y
	sta (dest),y
	dey
	bpl kopiujliniex
	lda sour
	clc
	adc #40
	sta sour
	bcc dodajdestx
	inc sour+1
dodajdestx
	lda dest
	clc
	adc #40
	sta dest
	bcc nextlinex
	inc dest+1
nextlinex
	dex
	bpl kopiujblokx
	rts

DLI
	pha
	Color $b0,$be
	Color $b2,$bc
	Color $b4,$ba
	Color $b6,$b8
	Color $b8,$b6
	Color $ba,$b4
	Color $bc,$b2
	Color $be,$b0
	Color $ce,$c0
	Color $cc,$c2
	Color $ca,$c4
	Color $c8,$c6
	Color $c6,$c8
	Color $c4,$ca
	Color $c2,$cc
	Color $c0,$ce
	Color $0,$0
	nextdli	dli2

dli2
	pha
	lda #$0e
	sta $d40a
	sta $d017
	nextdli	dli3


dli3
	pha
	Color $10,$12
	Color $12,$14
	Color $14,$16
	Color $16,$18
	Color $18,$1a
	Color $1a,$1c
	Color $1c,$1e
	Color $7e,$70
	nextdli	dli4

dli4
	pha
	Color $1c,$1c
	Color $1a,$1a
	Color $18,$18
	Color $16,$16
	Color $14,$14
	Color $12,$12
	Color $10,$10
	Color $e,$00
	nextdli	dli

dligame
	pha
	Color $e,$2
	Color $e,$4
	Color $e,$6
	Color $e,$8
	Color $e,$8
	Color $e,$6
	Color $e,$4
	Color $e,$2
	Color $e,$0
	nextdli	dligame

* = $2e00

DLMenu
	.byte $70,$70,$70,$70,$70+$80
	.byte $4f
	.word Title
	.dc 20 $0F
	.byte $0F+$80	
	.dc	30 $0f
	.byte $0f+$80	
	.dc 47 $0f
	.byte $4f
	.word Title+4000
	.dc 5 $0f
	.byte $0f+$80	
	.dc 48 $0F
;
	.byte $70
	.byte $42
	.word grzybsoniada
	.byte $41
	.word DlMenu

grzybsoniada
	.sbyte "           GRZYBSONIADA 2011                     "
DLGame
	.byte $70,$70
	.byte $4f
	.word GameScr
	.dc 99 $f
	.byte $4f
	.word Gamescr+4000
	.dc 98 $f
	
	.byte $20+$80
	.byte $42
	.word Score
	.byte $41
	.word dlgame

Score .sbyte " SCORE: 000000   LEVEL: 0    POWER:         "
	
*	= $3182
playerrmt	.incbin innuendo\piskiplayer
*	= $4000
			.incbin innuendo\piski.muz
*	= $5060
Gamescr		.incbin innuendo\backgr.raw
*	= $8060
Title		.incbin innuendo\Titlemorse.raw
* = $A000
fnt			.incbin innuendo\fonty.fnt
fazy		.incbin innuendo\fazy.raw
	
